;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; Circle Boo Stream
; A boo stream that moves in a circle like ball-n-chain or roto-disc
;
; By RussianMan. Based on Boo stream disassembly and Roto-Disc v.1.1
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

			!RAM_FrameCounterB	= $14
			!RAM_SpritesLocked	= $9D
			!RAM_SpriteNum		= !9E
			!RAM_SpriteSpeedY	= !AA
			!RAM_SpriteSpeedX	= !B6
			!RAM_SpriteYLo		= !D8
			!RAM_SpriteXLo		= !E4
			!OAM_DispX		= $0300|!Base2
			!OAM_DispY		= $0301|!Base2
			!OAM_Tile		= $0302|!Base2
			!OAM_Prop		= $0303|!Base2
			!RAM_SpriteYHi		= !14D4
			!RAM_SpriteXHi		= !14E0
			!RAM_SpriteDir		= !157C
			!RAM_SprObjStatus	= !1588
			!RAM_OffscreenHorz	= !15A0
			!RAM_SprOAMIndex	= !15EA
			!RAM_SpritePal		= !15F6
			!RAM_OffscreenVert	= !186C

			BooStreamTiles:
			db $88,$8C,$8E,$A8,$AA,$AE,$88,$8C

;original instructions on how to use extra bytes from roto-disc:

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;
;; HOW TO USE THE EXTRA BIT & EXTENSION BYTES
;;
;; \ Extra Bit - SET - Makes sprite travel clockwise.
;; /		     CLEAR - Makes sprite travel counter clockwise.
;;
;; \ Extra Byte 1 in LM will set the X radius of the circle the sprite will travel in.
;; | Extra Byte 2 in LM will set the Y radius of the circle the sprite will travel in.
;; / NOTE - If this are not equal to each other the sprite will move in an Ellipse..
;;
;; \ Extra Byte 3 in LM will set the speed of the sprites movement. 
;; / Non-Ridiculous range would be 00-0F.
;;
;; \ Extra Byte 4 in LM will set which half of the circle the sprite starts in.
;; | 00 - Bit Clear = Starts in bottom half of circle 
;; | 08	- Bit Set = Starts in top half of circle
;; |
;; | Values - 10,20,30,40,50,60,70,80,90,A0,B0,C0,D0,E0,F0
;; / Will start the sprite a different degrees around the semi circle respective to Bit3(08)
;;
;; EXAMPLE:
;; If you want the sprite to rotate clockwise, starting at 12'o'clock in 2 tile radius
;; in a perfect circle, but at a slowish speed. 
;; You would set Extra Bits to 3 in the sprite insertion dialog for clockwise rotation.
;; Then you set the Extension field too - 28 28 03 88
;; 28 for X radius and the next 28 for Y Radius. Theyre the same to make it a circle
;; 03 for a slow speed
;; Then 88 for position. 80 for the mid point of the semicircle 
;; and 08 to indicate the top half. 80+8==88
;;
;; Vanilla Roto Disc Values - 38 38 03 XX
;; 
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; sprite init JSL
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;


		print "INIT ",pc
		LDA !extra_bits,x		;move clockwise or counter clockwise depending on extra bit
		AND #$04
		BNE +

		INC !RAM_SpriteDir,x		;move clockwise if bit is set

+
		LDA !extra_byte_1,x		; \ X Radius
		STA !187B,x			; /

		LDA !extra_byte_2,x		; \ Y Radius
		STA !160E,x 			; /

		LDA !extra_byte_4,x             ; \ Set initial clock position
		AND #$F0			; | Mask lo nibble 
		STA !1626,x			; |
		LDA !extra_byte_4,x		; | 
		AND #$08			; | Check for bit 3 set
		BEQ +				; | If not zero assured
		LDA #$01			; | Else load 1 for high byte
+		STA !151C,x         		; /
		RTL


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; sprite code JSL
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

		print "MAIN ",pc
		PHB
		PHK
		PLB
		JSR Sprite_Code_Start
		PLB
		RTL

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; main
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;



Sprite_Code_Start:
		LDA #$01			;remove off screen
		%SubOffScreen()

		LDA $9D				;freeze flag = return
		BNE .Mathmatics

		LDA !extra_byte_3,x		; | But this time so we can add speed						; |
		LDY !RAM_SpriteDir,x
		BEQ +				; | ..Branch if set

		EOR #$FF			; | Invert it for opposite directio
		INC

;; ==== Make Y the "high byte" of the speed ($00 or $FF)
		LDY #$00			; \ 
+		CMP #$00			; |
		BPL +				; | Did speed end up Negative?
		DEY				; / If not make high byte FF

;; ==== Add to angle low and high byte
+		CLC	: ADC !1626,x		; \ Add Intial Lo Offset
		STA !1626,x			; | 
		TYA				; |	Reload FF to A	
		ADC !151C,x			; |	Add Initial Hi Offset
		AND #$01			; | Make sure its in 0 or 1
		STA !151C,x			; / 

.Mathmatics
;; ==== Save sprite position
		LDA !E4,x			; \  X Lo
		PHA				; | Preserve X/Y Pos to restore later
		LDA !14E0,x			; | X Hi
		PHA				; |
		LDA !D8,x			; | Y Lo
		PHA				; |
		LDA !14D4,x			; | Y Hi
		PHA				; /
					
;; ==== Input for Circle routines
		LDA !1626,x : STA $04 		; \ Load start pos Lo
		LDA !151C,x : STA $05 		; | and Hi
		LDA !187B,x : STA $06 		; / Load X Radius
		
		%CircleX()			; > X offset in $07-08

		LDA !160E,x : STA $06 		; > Reload scratch with Y Radius

		%CircleY()			; > Y offset in $09-0A
		
		LDA !E4,x			; \ Sprite X Lo Pos
		CLC : ADC $07			; | + Dissplacement
		STA !E4,x			; |
		LDA !14E0,x			; | Sprite X High Pos
		ADC $08				; | + Dissplacement
		STA !14E0,x			; /
		
		LDA !D8,x			; \ Sprite Y Lo Pos
		CLC : ADC $09			; | + Displacement
		STA !D8,x			; |
		LDA !14D4,x			; | Sprite Y Hi Pos
		ADC $0A				; | + Displacement
		STA !14D4,x			; /

		LDA $9D				; \ No point in checking interactions
		BNE RETURN_EXTRA		; / If sprites frozen

		TXA				;\ if sprite index or
		EOR !RAM_FrameCounterB		; | frame counter mod 8 =/= 0
		AND #$07			; |
		ORA !RAM_OffscreenVert,x 	; | or sprite is offscreen vertically,
		BNE CODE_038FC2			;/ branch

		JSR CODE_039020
CODE_038FC2:

		JSL $01A7DC|!BankB		; interact with Mario

		JSL $019138|!BankB		;interact with objects just like any self-respecting boo stream
		LDA !RAM_SprObjStatus,x		;see if interacted with anyting
		BEQ RETURN_EXTRA		;if not, don't change rotation

		LDA !RAM_SpriteDir,x		;change rotation direction
		EOR #$01			;
		STA !RAM_SpriteDir,x		;

RETURN_EXTRA:
		JSR Sprite_Graphics		; sprite GFX

;i think this check in unecessary - waste of space and additional cycles.
		;LDA !14C8,X			;\ if sprite status not normal,
		;CMP #$08			; |
		;BEQ .restore			;/ return

;		PLA : PLA			; \ If its dead, original position is uneeded.
;		PLA : PLA			; | Retrieve old values so we can..
;		RTS				; / ..Return


;; ==== Restore sprite position.
		PLA     				; \ Pull Back originals in reverse order
		STA !14D4,x				; | Y Hi
		PLA        				; |	
		STA !D8,x  				; | Y Lo
		PLA        				; |
		STA !14E0,x				; | X Hi
		PLA        				; |
		STA !E4,x				; | X Lo
		RTS					; / 

CODE_039020:
			LDY #$0B			; setup loop
CODE_039022:
			LDA $17F0|!Base2,y		;\ check if current slot in extended sprite list is empty
			BEQ CODE_039037			; | if so, continue
			DEY				; | else, decrease loop counter
			BPL CODE_039022			;/ and go to start of loop

			DEC $185D|!Base2		;\ if no empty slots were found, use table at $185D to determine which slot to overwrite
			BPL ADDR_039034			; |
			LDA #$0B			; |
			STA $185D|!Base2		; |
ADDR_039034:						; |
			LDY $185D|!Base2		;/
CODE_039037:
			LDA #$0A			;\ set extended sprite number: 0A (boo stream tile)
			STA $17F0|!Base2,y		;/
			LDA !RAM_SpriteXLo,x		;\ set x position for extended sprite
			STA $1808|!Base2,y		; |
			LDA !RAM_SpriteXHi,x		; |
			STA $18EA|!Base2,y		;/
			LDA !RAM_SpriteYLo,x		;\ set y position for extended sprite
			STA $17FC|!Base2,y		; |
			LDA !RAM_SpriteYHi,x		; |
			STA $1814|!Base2,y		;/
			LDA #$30			;\ set extended sprite timer
			STA $1850|!Base2,y		;/
			LDA !RAM_SpriteSpeedX,x		;\ set extended sprite x speed
			STA $182C|!Base2,y		;/
			RTS				; return


Sprite_Graphics:
			%GetDrawInfo()

			;LDA #!TileMap
			;STA !OAM_Tile,y

			LDA $00				;\ Sprite tile's X position
			STA !OAM_DispX,y		;/

			LDA $01				;\ Sprite tile's Y position
			STA !OAM_DispY,Y		;/

			LDA !RAM_SpritePal,x		; Sprite tile's property
			EOR #$40			;
			PHY				;
			LDY !RAM_SpriteDir,X		; flip sprite tile if necessary
			BEQ No_Flip			;
			EOR #$40			;
No_Flip:
			ORA $64				;
			PLY				;
			STA !OAM_Prop,Y			;

			LDA !RAM_FrameCounterB		;\ use frame counter to determine tile to use
			LSR #4				; |
			AND #$01			; |
			STA $00				; |
			TXA				; |
			AND #$03			; |
			ASL				; |
			ORA $00				; |
			PHX				; | preserve sprite index
			TAX				; |
			LDA BooStreamTiles,x 		; |
			STA !OAM_Tile,Y			;/
			PLX				; retrieve sprite index

			LDY #$02			; \ 460 = 2 (all 16x16 tiles)
			LDA #$00			;  | A = (number of tiles drawn - 1)
			JSL $01B7B3|!BankB		; / don't draw if offscreen
			RTS				; return